<?php
declare(strict_types=1);

function e(string $s): string {
  return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
}

/** BASE_URL from .env: e.g. https://grupoquattro.com/new/ */
function base_url(string $path = ''): string {
  $base = rtrim((string)($_ENV['BASE_URL'] ?? ''), '/');
  if ($base === '') {
    $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $base = $scheme . '://' . $host;
  }
  return $base . '/' . ltrim($path, '/');
}

function redirect(string $path): void {
  header('Location: ' . base_url($path));
  exit;
}
