<?php
declare(strict_types=1);

function csrf_init(): void {
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
  if (empty($_SESSION['csrf'])) {
    $_SESSION['csrf'] = bin2hex(random_bytes(32));
  }
}

function csrf_token(): string {
  csrf_init();
  return (string)$_SESSION['csrf'];
}

function csrf_validate(?string $token): bool {
  csrf_init();
  $sess = (string)($_SESSION['csrf'] ?? '');
  $form = (string)($token ?? '');
  return $sess !== '' && $form !== '' && hash_equals($sess, $form);
}
