<?php
declare(strict_types=1);

function auth_init(): void {
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
}

function auth_user(): ?array {
  auth_init();
  return $_SESSION['user'] ?? null;
}

function is_logged_in(): bool {
  return auth_user() !== null;
}

function require_login(): void {
  if (!is_logged_in()) {
    redirect('admin/auth/login.php');
  }
}

function auth_login(string $email, string $password): bool {
  auth_init();
  $pdo = db();

  $stmt = $pdo->prepare("SELECT id,email,pass_hash,is_active FROM users WHERE email=? LIMIT 1");
  $stmt->execute([$email]);
  $u = $stmt->fetch();

  if (!$u || (int)$u['is_active'] !== 1) return false;
  if (!password_verify($password, (string)$u['pass_hash'])) return false;

  $r = $pdo->prepare("SELECT r.slug FROM roles r JOIN user_roles ur ON ur.role_id=r.id WHERE ur.user_id=?");
  $r->execute([(int)$u['id']]);
  $roles = [];
  foreach ($r->fetchAll() as $row) $roles[] = (string)$row['slug'];

  $_SESSION['user'] = [
    'id' => (int)$u['id'],
    'email' => (string)$u['email'],
    'roles' => $roles
  ];
  return true;
}

function auth_logout(): void {
  auth_init();
  $_SESSION = [];
  if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
      $params["path"], $params["domain"], $params["secure"], $params["httponly"]
    );
  }
  session_destroy();
}
