<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/Config/config.php';

auth_init();
csrf_init();
$lang = i18n_lang();

$errorKey = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_validate($_POST['csrf'] ?? '')) {
    $errorKey = 'login.csrf';
  } else {
    $email = trim((string)($_POST['email'] ?? ''));
    $pass  = (string)($_POST['password'] ?? '');
    if (auth_login($email, $pass)) {
      redirect('admin/index.php');
    }
    $errorKey = 'login.invalid';
  }
}
?><!doctype html>
<html lang="<?= e($lang) ?>">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= e(t('login.title')) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5" style="max-width:420px;">
  <div class="text-center mb-4">
    <h1 class="h4 mb-1"><?= e(t('app.name')) ?></h1>
    <div class="text-muted small"><?= e(t('login.title')) ?></div>
  </div>

  <div class="card shadow-sm">
    <div class="card-body p-4">
      <?php if ($errorKey): ?>
        <div class="alert alert-danger"><?= e(t($errorKey)) ?></div>
      <?php endif; ?>

      <form method="post" autocomplete="off">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <div class="mb-3">
          <label class="form-label"><?= e(t('login.email')) ?></label>
          <input class="form-control" type="email" name="email" required>
        </div>
        <div class="mb-3">
          <label class="form-label"><?= e(t('login.password')) ?></label>
          <input class="form-control" type="password" name="password" required>
        </div>
        <button class="btn btn-primary w-100" type="submit"><?= e(t('login.submit')) ?></button>
      </form>
    </div>
  </div>

  <div class="text-center mt-3">
    <a class="btn btn-sm btn-outline-secondary" href="?lang=pl">PL</a>
    <a class="btn btn-sm btn-outline-secondary" href="?lang=en">EN</a>
    <a class="btn btn-sm btn-outline-secondary" href="?lang=es">ES</a>
  </div>
</div>
</body>
</html>
